#  Copyright (C) 2025
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from dataclasses import dataclass
from typing import Any

from frozendict import frozendict
from http_tools import IncomingRequest

from .call_parameter import CallParameter
from .spec_parameter import SpecParameter


@dataclass(frozen=True, kw_only=True)
class LiteralParameter(CallParameter):
    value: Any

    async def get(self, incoming_request: IncomingRequest, security_kwargs: dict[str, Any]) -> Any:
        return self.value

    def get_spec_parameters(self) -> frozendict[SpecParameter, None]:
        return frozendict()

    def __repr__(self):
        return f'{self.__class__.__name__}({", ".join(self._get_repr_parts())})'

    __str__ = __repr__
