#  Copyright (C) 2025
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from dataclasses import dataclass
from typing import Any, ClassVar

from http_tools import IncomingRequest

from .parameter_location import ParameterLocation
from .spec_parameter import SpecParameter


@dataclass(frozen=True, slots=True, kw_only=True)
class HeaderParameter(SpecParameter):
    location: ClassVar[ParameterLocation] = ParameterLocation.header

    def _get(self, incoming_request: IncomingRequest) -> Any:
        return incoming_request.metadata.header_name_to_value[self.name]

    def __repr__(self):
        return f'{self.__class__.__name__}({", ".join(self._get_repr_parts())})'

    __str__ = __repr__
