#  Copyright (C) 2021
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasya Svintsov <v.svintsov@techokert.ru>

from dataclasses import dataclass

from aioboto3 import client
from aiobotocore.session import ClientCreatorContext


class AmazonSESConnector:
    @dataclass
    class Config:
        access_key: str
        secret_key: str
        region_name: str
        endpoint_url: str = None
        use_ssl: bool = True

    def __init__(self, config: Config):
        self._config = config

    def get_client_creator(self) -> ClientCreatorContext:
        client_session = client(
            service_name="ses",
            region_name=self._config.region_name,
            aws_access_key_id=self._config.access_key,
            aws_secret_access_key=self._config.secret_key,
            endpoint_url=self._config.endpoint_url)
        return client_session
