## Welcome to EmailSender

Asynchronous SMTP/AmazonSES/HTTP(SelfEmailSender) client for asyncio and Python.

## Library Installation

```
pip install --extra-index-url https://pypi2.abm-jsc.ru email-tools-abm
```

## Quick Start


#### Send email using SMTP client
```python
import asyncio
from email_tools.email_sender import EmailSender
from http_tools.attached_file import AttachedFile

async def send_email_using_smtp_client():
    email_sender = EmailSender(
        config=EmailSender.SMTPConfig(
            server_hostname="smtp.gmail.com",
            server_ssl_port=465,
            username="example@gmail.com",
            password="password",
            default_from_email="example@gmail.com",
        ), 
        context=EmailSender.Context()
    )
    await email_sender.send(
        to_recipients=["v.svintsov@technokert.ru", "v.svintsov.2@technokert.ru"], 
        subject="ExampleSubject", 
        body="ExampleBody",
        attachments=[AttachedFile(b"1", "file1", "application"), AttachedFile(b"", "file2", "application")]
    )


asyncio.run(send_email_using_smtp_client())
```

#### Send email using AmazonSES client
```python
import asyncio
from email_tools.email_sender import EmailSender


async def send_email_using_amazon_ses_client():
    email_sender = EmailSender(
        config=EmailSender.AmazonSESConfig(
            access_key="access_key",
            secret_key="secret_key",
            region_name="eu-central-1",
            default_from_email="example@verifiedcompany.com",
        ),
        context=EmailSender.Context()
    )
    await email_sender.send(
        to_recipients="v.svintsov@technokert.ru", 
        subject="ExampleSubject", 
        body="ExampleBody",
        cc_recipients="CC.v.svintsov@technokert.ru"
    )


asyncio.run(send_email_using_amazon_ses_client())
```

#### Send email using OuterHttpServer with EmailSender client
```python
import asyncio
from email_tools.email_sender import EmailSender
from aiohttp import ClientSession


async def send_email_using_outer_email_sender():
    email_sender = EmailSender(
        config=EmailSender.HTTPConfig(
            location="http://outer_email_sender",
        ),
        context=EmailSender.Context(
            session=ClientSession()
        )
    )
    await email_sender.send(
        to_recipients="v.svintsov@technokert.ru", 
        subject="ExampleSubject", 
        body="ExampleBody",
        cc_recipients=["CC.v.svintsov@technokert.ru"],
        bcc_recipients="BCC.v.svintsov@technokert.ru",
    )


asyncio.run(send_email_using_outer_email_sender())

```