#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from dataclasses import dataclass

from entity_read import sql
from entity_read.entity import Entity
from entity_read.sql.atoms import Selectable

from .expression import Expression


@dataclass(frozen=True, repr=False)
class Alias(Expression):
    body: Expression
    key: str

    def __post_init__(self):
        assert "'" not in self.key, 'key should not contain symbol "\'"'

    def eval(self, entity_type: type[Entity], variables: dict[str, Selectable]) -> sql.atoms.alias.Alias:
        body = self.body.eval(entity_type, variables)
        return sql.atoms.alias.Alias(body=body, key=self.key)

    def shortcut(self) -> str:
        try:
            return f"{self.body.shortcut()}.as('{self.key}')"
        except:
            raise
