### RunMarkdown
Extract and run code blocks from .md files
### Пример проверки кода на python
Код, маркированный, как python, будет запущен с помощью python
```python 
print(2+3)
```
Следующий блок текста за исполняемым блоком будет использоваться для проверки результата  
```text
5
```
### Пример создания и последующего импорта файла на python
Если текст перед блоком кода заканчивается жирной строкой, начинающийся с `file://` и заканчивающийся на `:`, 
то код из блока будет предварительно помешён в файл(можно указывать три слеша подряд, чтобы не создавалась ссылка)  
Например, создадим **file:///summarize.py:**
```python 
def summarize(a: int, b: int) -> int:
    return a + b
```
Если после блока кода нет текстового блока, то код запускается, но проверка не выполняется  
Импортируем созданный файл
```python
from summarize import summarize
print(summarize(3, 4))
```
Проверим, что вывелось
```
7
```
Созданные файлы в текущей версии живут до окончания всего запуска, но это может измениться в дальнейшем
### Пример проверки кода, не завершающегося за 1 сек
Помимо `python` можно также запускать код на `bash`/`sh`
```bash
for i in {1..20}; do echo $i; sleep 0.3; done
```
за одну секунду ожидаем первые 4 числа:
```
1
2
3
4
```


### Пример проверки кода, c шаблонизированным результатом
Этот механизм работает только для текстовых результатов
#### Пример проверки кода, c шаблонизированной строкой
```python
import datetime
print(datetime.datetime.now().year)
```
Ожидаем, что текущий год начинается с `20`
```
20...
```
#### Пример проверки кода, c произвольными наборами строк
```python
import datetime
[print("hay") for _ in range(datetime.datetime.now().second // 10)]
print('needle')
[print("hay") for _ in range(datetime.datetime.now().minute // 10)]
```
Ожидаем, что текущий год начинается с `20`
```
***
needle
***
```


### Пример проверки кода, возвращающего json
В json порядок атрибутов объектов не гарантирован, что может стать проблемой при текстовом сравнении  
Кроме того минифицированный json (без переносов строк и пробелов) эквивалентен своей полной форме 
```python
import json
print(json.dumps({"a": 1, "b": 2}))  # напечатает строку '{"a": 1, "b": 2}'
```
опишем ожидаемый результат в развёрнутом виде:
```json
{
  "b": 2,
  "a": 1
}
```

### Пример проверки кода, возвращающего из python stderr
Кроме стандартного потока вывода(stdout) есть ещё и поток ошибок(stderr), они объединяются в единый вывод
```python
import sys
print("something")
print('other', file=sys.stderr)
print('''third\nforth''', file=sys.stderr)
```
Опишем ожидаемый результат в развёрнутом виде:
```text
something
other
third
forth
```

### Пример многострочника c кавычками на bash