#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasiliev Ivan <i.vasiliev@technokert.ru>
from dataclasses import dataclass

from .entity_server_connector import EntityServerConnector


class BaseAuthEntityServerConnector(EntityServerConnector):

    @dataclass
    class Context(EntityServerConnector.Context):
        project_name: str

    Config = EntityServerConnector.Config

    def __init__(self, config: Config, context: Context) -> None:
        self._server_name = context.server_name
        super(BaseAuthEntityServerConnector, self).__init__(config, context)

    def _construct_headers(self) -> dict[str, str]:
        headers = super(BaseAuthEntityServerConnector, self)._construct_headers()
        headers["server_name"] = self._server_name
        return headers
