#  Copyright (C) 2025
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
def snake_case_to_camel_case(snake_case_string: str, first_camel: bool = True) -> str:
    """
    Converts a snake_case string to camelCase.
    """
    words = snake_case_string.split('_')
    if first_camel:
        return ''.join(word.capitalize() for word in words)
    else:
        return words[0] + ''.join(word.capitalize() for word in words[1:])
