#  Copyright (C) 2025
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from abc import ABC
from dataclasses import dataclass
from typing import Generic, ClassVar, Mapping

from frozendict import frozendict
from init_helpers import Jsonable

from openapi_tools.spec import SpecResource, SpecRef
from .security_scheme import SecurityScheme, AuthInfo
from .security_scheme_type import SecuritySchemeType


@dataclass(frozen=True)
class OAuth2SecurityScheme(SecurityScheme, Generic[AuthInfo], ABC):
    type_: ClassVar[SecuritySchemeType] = SecuritySchemeType.oauth2
    # flow_to_info: str ???

    def get_spec_dict(self, dependency_to_ref: Mapping[SpecResource, SpecRef]) -> frozendict[str, Jsonable]:
        raise NotImplementedError
