#  Copyright (C) 2025
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import functools
from abc import ABC
from dataclasses import dataclass
from typing import Mapping, ClassVar

from frozendict import frozendict
from init_helpers import Jsonable

from openapi_tools.spec.spec_resource import SpecResource, SpecRef
from openapi_tools.spec.schema.base_schema import BaseSchema
from openapi_tools.spec.schema.schema_format import SchemaFormat


@dataclass(frozen=True, slots=True)
class TypeSchema(BaseSchema, ABC):
    type_: ClassVar[str]
    format_: SchemaFormat | None = None

    def get_spec_dict(self, dependency_to_ref: Mapping['SpecResource', SpecRef]) -> frozendict[str, Jsonable]:
        result: dict[str, Jsonable] = {'type': self.type_}
        if self.format_ is not None:
            result['format'] = self.format_
        return frozendict(result | BaseSchema.get_spec_dict(self, dependency_to_ref))

    @functools.cache
    def _get_repr_parts(self) -> tuple[str, ...]:
        parts = list(BaseSchema._get_repr_parts(self))
        parts += [f'format_={self.format_!r}'] if self.format_ else []
        return tuple(parts)
