#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasiliev Ivan <i.vasiliev@technokert.ru>
from more_itertools import first

from clickhouse_tools.elements.abstract.selectable import Selectable
from clickhouse_tools.elements.column import Column


# TODO move to clickhouse tools
class Distinct(Selectable):
    def __init__(self, column: Column):
        super(Distinct, self).__init__(column.clickhouse_type, nullable=False, name=f"{column.name}_distinct")
        self.column=column

    def to_selector(self) -> str:
         return f"distinct({self.column.name})"


class DistinctOn(Selectable):
    def __init__(self, distinct_on_columns: list[Column]):
        if len(distinct_on_columns) != 1:
            raise NotImplementedError("DistinctOn working only with one column")
        # TODO problem is that we need column.clickhouse_type to cast CH response;
        #  figure out how to work with several columns in one Selectable
        column = first(distinct_on_columns)
        super(DistinctOn, self).__init__(column.clickhouse_type, nullable=False, name=f"{column.name}_distinct_on")
        self.column=column

    def to_selector(self) -> str:
         return f"distinct on({self.column.name})"

