from typing import Any
import json
import urllib.parse


def parse_query_components(query_components: dict[str, Any]) -> dict[str, Any]:
    parsed_query = query_components.copy()
    for component_name, component_value in query_components.items():
        if "{" and "}" or "[" and "]" in component_value:
            try:
                parsed_query[component_name] = json.loads(urllib.parse.unquote_plus(component_value))
            except json.JSONDecodeError:
                pass
        elif component_value.lower() == "none" or component_value.lower() == "null":
            parsed_query[component_name] = None
    return parsed_query
