#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import abc
from dataclasses import dataclass
from typing import ClassVar

from typed_json.typed_In_dumps import TypedInDumps


@dataclass(frozen=True, kw_only=True, repr=False)
class QueryToken(abc.ABC, TypedInDumps):
    __namespace__: ClassVar[str] = "ES"  # called entity server earlier
    keep_subquery: ClassVar[bool] = False

    @abc.abstractmethod
    def shortcut(self) -> str:
        pass

    # @abc.abstractmethod
    # def eval(self, entity_type: type[Entity], variables: dict[str, Selectable]) -> sql.atoms.node.Node:
    #     pass
