#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from typing import TypeVar, Awaitable

from .strict_gather import strict_gather

K = TypeVar("K")
V = TypeVar("V")


async def await_dict_values(dict_with_awaitables: dict[K, Awaitable[V]]) -> dict[K, V]:
    awaited_values = await strict_gather(*dict_with_awaitables.values())
    return dict(zip(dict_with_awaitables.keys(), awaited_values))
