#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from dataclasses import dataclass

from entity_read import sql
from entity_read.entity import Entity
from entity_read.sql.atoms import Selectable

from .expression import Expression


@dataclass(frozen=True, kw_only=True, repr=False)
class Alias(Expression):
    body: Expression
    key: str

    def eval(self, entity_type: type[Entity], variables: dict[str, Selectable]) -> sql.atoms.alias.Alias:
        body = self.body.eval(entity_type, variables)
        return sql.atoms.alias.Alias(body=body, key=self.key)

    def shortcut(self) -> str:
        return f"col.{self.key}"
