#  Copyright (C) 2021
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasya Svintsov <v.svintsov@techokert.ru>

import hashlib
from typing import Union


def generate_md5_hash(payload: Union[bytes, str]) -> str:
    m = hashlib.md5()
    payload = payload if isinstance(payload, bytes) else payload.encode('utf-8')
    m.update(payload)
    return m.hexdigest()


def generate_sha512_hash(payload: Union[bytes, str]) -> str:
    m = hashlib.sha512()
    payload = payload if isinstance(payload, bytes) else payload.encode('utf-8')
    m.update(payload)
    return m.hexdigest()
