from entity_query import Condition, Column, literal, Exists, SubQuery, Relation, ConditionOr

from abstract_entity_connector_abm.comparison_operator import ComparisonOperator, OPERATOR_MAP
from abstract_entity_connector_abm.filter_by import FilterBy


def cast_filters_to_condition(filter_by: list[FilterBy] | None = None,
                              search_by: list[FilterBy] | None = None) -> list[Condition] | None:

    def get_op_name(comparison_operator: ComparisonOperator) -> str:
        try:
            return OPERATOR_MAP[comparison_operator]
        except KeyError:
            raise ValueError(f"Unknown ComparisonOperator: {comparison_operator}")

    def make_condition_from_filter(f: FilterBy) -> Condition:
        result = None
        for part in reversed(f.attribute.split('.')):
            if not result:
                result = Condition(key=get_op_name(f.operator), args=[Column(key=part), literal(f.value)])
            else:
                result = Exists(SubQuery(over=Relation(key=part), attrs=[], vars={}, filters=[result], orders=[]))
        return result

    result = [make_condition_from_filter(filter_) for filter_ in filter_by or []]
    if search_by:
        result.append(ConditionOr(*[make_condition_from_filter(search_) for search_ in search_by]))
    return result
