# coding: utf-8

"""
    Mentortools Chat API

    Mentortools service for chatting

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic import BaseModel, Field, StrictInt

class ChatSessionGet(BaseModel):
    """
    ChatSessionGet
    """
    id: StrictInt = Field(...)
    chat_id: StrictInt = Field(...)
    creator_id: StrictInt = Field(...)
    credentials: Dict[str, Any] = Field(...)
    created_at: StrictInt = Field(...)
    ended_at: Optional[StrictInt] = None
    __properties = ["id", "chat_id", "creator_id", "credentials", "created_at", "ended_at"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ChatSessionGet:
        """Create an instance of ChatSessionGet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ChatSessionGet:
        """Create an instance of ChatSessionGet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ChatSessionGet.parse_obj(obj)

        _obj = ChatSessionGet.parse_obj({
            "id": obj.get("id"),
            "chat_id": obj.get("chat_id"),
            "creator_id": obj.get("creator_id"),
            "credentials": obj.get("credentials"),
            "created_at": obj.get("created_at"),
            "ended_at": obj.get("ended_at")
        })
        return _obj


