#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasya Svintsov <v.svintsov@techokert.ru>

from dataclasses import dataclass

from http_tools import HttpServer, IncomingRequest, Answer, FileAnswer
from http_tools.mime_types import ContentType
from init_helpers import custom_dumps
from openapi_tools.open_api_server import OpenApiServer


class OpenApiSpecificationHandler:
    @dataclass
    class Context:
        http_server: HttpServer
        open_api_server: OpenApiServer

    def __init__(self, context: Context) -> None:
        self._context = context
        self._register_handlers()

    def _register_handlers(self) -> None:
        path = '/open_api_specification/get'
        self._context.http_server.register_handler(path, self.get_open_api_specification)

    async def get_open_api_specification(self, _: IncomingRequest) -> Answer:
        spec = self._context.open_api_server.wrapper.get_spec_dict()
        content = custom_dumps(spec, indent=2)
        return FileAnswer(content, file_name='open_api_specification.json', content_type=ContentType.Json)
