#  Copyright (C) 2022
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasiliev Ivan <i.vasiliev@technokert.ru>
import logging
from dataclasses import dataclass
from typing import Any, Optional, Sequence, Tuple, Awaitable, Callable
from .producer import Producer

logger = logging.getLogger(__file__)


class TopicSender:
    @dataclass
    class Context:
        producer: Producer

    @dataclass
    class Config:
        topic: str

    def __init__(self,
                 config: Config,
                 context: Context,
                 key_serializer: Callable[[Any], bytes],
                 value_serializer: Callable[[Any], bytes]) -> None:
        self.config = config
        self.context = context
        self.key_serializer = key_serializer
        self.value_serializer = value_serializer

    async def produce(self, value: Optional[Any] = None, key: Optional[Any] = None, partition: Optional[int] = None,
                      timestamp_ms: Optional[int] = None, headers: Optional[Sequence[Tuple[str, bytes]]] = None
                      ) -> Awaitable:
        return await self.context.producer.produce(self.config.topic,
                                                   value=self.value_serializer(value),
                                                   key=self.key_serializer(key),
                                                   partition=partition,
                                                   timestamp_ms=timestamp_ms,
                                                   headers=headers)
