# apple-connector
Mentortools

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 1.0.0+2065852617
- Generator version: 7.14.0
- Build package: org.openapitools.codegen.languages.PythonPydanticV1ClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import apple_connector
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import apple_connector
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import apple_connector
from apple_connector.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = apple_connector.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
async with apple_connector.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = apple_connector.SendCheckReviewsApi(api_client)
    bundle_identifier = apple_connector.BundleIdentifier() # BundleIdentifier | 

    try:
        # Submit for review
        api_response = await api_instance.create_review_reviews_create_post(bundle_identifier)
        print("The response of SendCheckReviewsApi->create_review_reviews_create_post:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling SendCheckReviewsApi->create_review_reviews_create_post: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*SendCheckReviewsApi* | [**create_review_reviews_create_post**](docs/SendCheckReviewsApi.md#create_review_reviews_create_post) | **POST** /reviews/create | Submit for review
*SendCheckReviewsApi* | [**list_reviews_reviews_get_list_post**](docs/SendCheckReviewsApi.md#list_reviews_reviews_get_list_post) | **POST** /reviews/get_list | List reviews
*SetupAppApi* | [**fill_app_information_setup_app_setup_app_patch**](docs/SetupAppApi.md#fill_app_information_setup_app_setup_app_patch) | **PATCH** /setup_app/setup_app | Fill app information
*SetupAppScreenshotsApi* | [**update_screenshots_app_screenshots_screenshots_post**](docs/SetupAppScreenshotsApi.md#update_screenshots_app_screenshots_screenshots_post) | **POST** /app_screenshots/screenshots | Update screenshots
*SetupBundleIDApi* | [**check_bundle_id_bundle_id_check_bundle_id_post**](docs/SetupBundleIDApi.md#check_bundle_id_bundle_id_check_bundle_id_post) | **POST** /bundle_id/check_bundle_id | Check Bundle ID
*SetupBundleIDApi* | [**create_bundle_id_bundle_id_create_bundle_id_post**](docs/SetupBundleIDApi.md#create_bundle_id_bundle_id_create_bundle_id_post) | **POST** /bundle_id/create_bundle_id | Create Bundle ID
*SetupBundleIDApi* | [**fix_bundle_id_bundle_id_update_bundle_id_patch**](docs/SetupBundleIDApi.md#fix_bundle_id_bundle_id_update_bundle_id_patch) | **PATCH** /bundle_id/update_bundle_id | Fix Bundle ID
*SetupIapApi* | [**create_iap_app_iap_create_iap_post**](docs/SetupIapApi.md#create_iap_app_iap_create_iap_post) | **POST** /app_iap/create_iap | Create IAP
*SetupIapApi* | [**list_iap_app_iap_iap_list_post**](docs/SetupIapApi.md#list_iap_app_iap_iap_list_post) | **POST** /app_iap/iap_list | List IAPs
*SetupIapApi* | [**list_subscriptions_app_iap_subscription_list_post**](docs/SetupIapApi.md#list_subscriptions_app_iap_subscription_list_post) | **POST** /app_iap/subscription_list | List subscriptions
*SetupIapApi* | [**update_urls_app_iap_product_sandbox_urls_patch**](docs/SetupIapApi.md#update_urls_app_iap_product_sandbox_urls_patch) | **PATCH** /app_iap/product_sandbox_urls | Update IAP URLs
*SetupInfoApi* | [**get_app_id_app_info_app_id_post**](docs/SetupInfoApi.md#get_app_id_app_info_app_id_post) | **POST** /app_info/app_id | Get App ID
*SetupInfoApi* | [**get_app_versions_app_info_app_versions_post**](docs/SetupInfoApi.md#get_app_versions_app_info_app_versions_post) | **POST** /app_info/app_versions | Get App Versions
*UsersAndCredentialsApi* | [**check_credential_users_validate_credentials_post**](docs/UsersAndCredentialsApi.md#check_credential_users_validate_credentials_post) | **POST** /users/validate_credentials | Validate credentials
*UsersAndCredentialsApi* | [**invite_service_account_users_service_account_post**](docs/UsersAndCredentialsApi.md#invite_service_account_users_service_account_post) | **POST** /users/service_account | Invite service account
*DefaultApi* | [**metrics_metrics_get**](docs/DefaultApi.md#metrics_metrics_get) | **GET** /metrics | Metrics


## Documentation For Models

 - [ASCCredentials](docs/ASCCredentials.md)
 - [AppScreenshotDisplayType](docs/AppScreenshotDisplayType.md)
 - [BundleCapabilities](docs/BundleCapabilities.md)
 - [BundleIdCapabilityType](docs/BundleIdCapabilityType.md)
 - [BundleIdentifier](docs/BundleIdentifier.md)
 - [ContentRightsDeclaration](docs/ContentRightsDeclaration.md)
 - [CreateBundleId](docs/CreateBundleId.md)
 - [CredentialsCheckResult](docs/CredentialsCheckResult.md)
 - [DeviceFamily](docs/DeviceFamily.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [IAPCreateParams](docs/IAPCreateParams.md)
 - [IAPProduct](docs/IAPProduct.md)
 - [InAppPurchaseType](docs/InAppPurchaseType.md)
 - [ReleaseType](docs/ReleaseType.md)
 - [Result](docs/Result.md)
 - [ResultAppId](docs/ResultAppId.md)
 - [ResultAppVersions](docs/ResultAppVersions.md)
 - [ResultBundleId](docs/ResultBundleId.md)
 - [ResultBundleIdCheck](docs/ResultBundleIdCheck.md)
 - [ResultIAPList](docs/ResultIAPList.md)
 - [ReviewResultApp](docs/ReviewResultApp.md)
 - [ReviewResultIAP](docs/ReviewResultIAP.md)
 - [ReviewResultItems](docs/ReviewResultItems.md)
 - [ReviewStatusResult](docs/ReviewStatusResult.md)
 - [ReviewType](docs/ReviewType.md)
 - [Screenshot](docs/Screenshot.md)
 - [ScreenshotSets](docs/ScreenshotSets.md)
 - [ScreenshotSetsData](docs/ScreenshotSetsData.md)
 - [SetAppUpdateParams](docs/SetAppUpdateParams.md)
 - [SetupAppParams](docs/SetupAppParams.md)
 - [SubscriptionStatusUrlVersion](docs/SubscriptionStatusUrlVersion.md)
 - [ValidationError](docs/ValidationError.md)
 - [ValidationErrorLocInner](docs/ValidationErrorLocInner.md)
 - [Webhooks](docs/Webhooks.md)
 - [WrappedResponse](docs/WrappedResponse.md)
 - [WrappedResponseCredentialsCheckResult](docs/WrappedResponseCredentialsCheckResult.md)
 - [WrappedResponseResultAppId](docs/WrappedResponseResultAppId.md)
 - [WrappedResponseResultAppVersions](docs/WrappedResponseResultAppVersions.md)
 - [WrappedResponseResultBundleId](docs/WrappedResponseResultBundleId.md)
 - [WrappedResponseResultBundleIdCheck](docs/WrappedResponseResultBundleIdCheck.md)
 - [WrappedResponseResultIAPList](docs/WrappedResponseResultIAPList.md)
 - [WrappedResponseReviewStatusResult](docs/WrappedResponseReviewStatusResult.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization

Endpoints do not require authorization.


## Author




