#  Copyright (C) 2021
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
#
from typing import Optional, Mapping, Any

from init_helpers.custom_json import Jsonable

from http_tools import AbmServiceConnector


class AbmServiceAuthedConnector(AbmServiceConnector):
    @staticmethod
    def _update_headers_with_auth(headers: Optional[Mapping[str, str]] = None, token: str = None) -> dict[str, str]:
        result = dict(headers) if headers else {}
        result |= {'Authorization': f"Bearer {token}"} if token else {}
        return result

    async def get(self,
                  path: str,
                  url_query: Optional[Mapping[str, Any]] = None,
                  headers: Optional[Mapping[str, str]] = None,
                  token: str = None,
                  timeout_sec: Optional[float] = None) -> Any:
        headers = self._update_headers_with_auth(headers, token)
        return await super().get(path=path, url_query=url_query, headers=headers, timeout_sec=timeout_sec)

    async def post(self,
                   path: str,
                   payload: bytes | Jsonable,
                   url_query: Optional[Mapping[str, Any]] = None,
                   headers: Optional[Mapping[str, str]] = None,
                   token: str = None,
                   timeout_sec: Optional[float] = None) -> Any:
        headers = self._update_headers_with_auth(headers, token)
        return await super().post(
            path=path, payload=payload, url_query=url_query, headers=headers, timeout_sec=timeout_sec)
