#  Copyright (C) 2022
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasya Svintsov <v.svintsov@techokert.ru>
import logging
from typing import TypeVar, Type

from init_helpers.custom_json import Jsonable
from init_helpers.dict_to_dataclass import dict_to_dataclass


logger = logging.getLogger(__name__)


T = TypeVar('T')


def cast_jsonable_to_dataclass(jsonable: Jsonable, *, cls: Type[T]) -> T:
    try:
        return dict_to_dataclass(jsonable, cls)
    except (TypeError, KeyError) as er:
        error_description = f'Cast jsonable to dataclass failed: {repr(er)}. jsonable: {jsonable}.'
        logger.error(error_description)
        raise ValueError(error_description)
