# coding: utf-8

"""
    Mentortools Public API

    Mentortools public API service

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from landing_page_server_connector.models.course_access_type_str_enum import CourseAccessTypeStrEnum
from landing_page_server_connector.models.course_module_view_type_str_enum import CourseModuleViewTypeStrEnum
from landing_page_server_connector.models.course_payment_type_str_enum import CoursePaymentTypeStrEnum

class CourseUpdate(BaseModel):
    """
    CourseUpdate
    """
    title: StrictStr = Field(default=..., description="Title of the course")
    image_id: Optional[StrictStr] = Field(default=None, description="ID of the course image on file service")
    description: Optional[StrictStr] = Field(default='', description="Description of the course")
    url: Optional[StrictStr] = Field(default='', description="URL of the sales page, if landing page is not used")
    payload: Optional[StrictStr] = Field(default='', description="Additional payload for the course, text or HTML content")
    module_view_type: Optional[CourseModuleViewTypeStrEnum] = None
    payment_type: Optional[CoursePaymentTypeStrEnum] = None
    course_access_type: Optional[CourseAccessTypeStrEnum] = None
    number_days_access: Optional[StrictInt] = 0
    is_active: StrictBool = Field(default=..., description="Whether the course is active and available for users")
    is_secret: StrictBool = Field(default=..., description="Whether the course is secret and not listed publicly on dashboard, does not affect visibility in the mobile app")
    is_archived: StrictBool = Field(default=..., description="Whether the course is archived (deleted and to be removed from database)")
    is_displayed_in_app: StrictBool = Field(default=..., description="Whether the course is displayed in mobile app, unrelated to the course visibility in the web app")
    is_offline_downloadable: StrictBool = Field(default=..., description="Whether the course can be downloaded for offline access in the mobile app")
    available_at: Optional[StrictInt] = None
    launch_date_enabled: Optional[StrictBool] = False
    launch_date: Optional[StrictInt] = 0
    order: StrictInt = Field(default=..., description="Order of the course in the list. Required for updates.")
    __properties = ["title", "image_id", "description", "url", "payload", "module_view_type", "payment_type", "course_access_type", "number_days_access", "is_active", "is_secret", "is_archived", "is_displayed_in_app", "is_offline_downloadable", "available_at", "launch_date_enabled", "launch_date", "order"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CourseUpdate:
        """Create an instance of CourseUpdate from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CourseUpdate:
        """Create an instance of CourseUpdate from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CourseUpdate.parse_obj(obj)

        _obj = CourseUpdate.parse_obj({
            "title": obj.get("title"),
            "image_id": obj.get("image_id"),
            "description": obj.get("description") if obj.get("description") is not None else '',
            "url": obj.get("url") if obj.get("url") is not None else '',
            "payload": obj.get("payload") if obj.get("payload") is not None else '',
            "module_view_type": obj.get("module_view_type"),
            "payment_type": obj.get("payment_type"),
            "course_access_type": obj.get("course_access_type"),
            "number_days_access": obj.get("number_days_access") if obj.get("number_days_access") is not None else 0,
            "is_active": obj.get("is_active"),
            "is_secret": obj.get("is_secret"),
            "is_archived": obj.get("is_archived"),
            "is_displayed_in_app": obj.get("is_displayed_in_app"),
            "is_offline_downloadable": obj.get("is_offline_downloadable"),
            "available_at": obj.get("available_at"),
            "launch_date_enabled": obj.get("launch_date_enabled") if obj.get("launch_date_enabled") is not None else False,
            "launch_date": obj.get("launch_date") if obj.get("launch_date") is not None else 0,
            "order": obj.get("order")
        })
        return _obj


