#  Copyright (C) 2021
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasya Svintsov <v.svintsov@techokert.ru>

from contextlib import asynccontextmanager
from typing import Hashable

from ..tools.lock_wrapper import LockWrapper


class KeyLock:
    def __init__(self) -> None:
        self.key_to_lock: dict[Hashable, LockWrapper] = {}

    @asynccontextmanager
    async def restrict(self, key: Hashable) -> None:
        key_to_lock = self.key_to_lock.setdefault(key, LockWrapper())
        await key_to_lock.acquire()
        try:
            yield
        finally:
            key_to_lock.release()
            if not key_to_lock.depth:
                del self.key_to_lock[key]
