from dataclasses import dataclass, field


@dataclass
class Actor:
    id: int | str
    token: str | None


@dataclass(frozen=False)
class UserActor(Actor):
    id: int
    token: str


@dataclass(frozen=False)
class ServerActor(Actor):
    id: str
    token: None = field(init=False, repr=False, default=None)
