#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>


class SqlContext:
    def __init__(self, self_table_name: str, key_to_param: dict | None = None):
        self.self_table_name = self_table_name
        self.bind_params = key_to_param is None
        self.key_to_param = key_to_param

    def get_self(self):
        return self.self_table_name

    def register_parameter(self, value):
        key = f'l{len(self.key_to_param)}'
        self.key_to_param[key] = value
        return ":" + key
