# coding: utf-8

"""
    Mentortools Public API

    Mentortools public API service

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr

class ModuleLessonPatch(BaseModel):
    """
    ModuleLessonPatch
    """
    submodule_id: Optional[StrictInt] = Field(default=None, description="ID of the submodule this lesson belongs to, if not set, it will be not updated")
    thread_id: Optional[StrictInt] = Field(default=None, description="ID of the community thread this lesson belongs to, if not set, it will be not updated")
    image_id: Optional[StrictStr] = Field(default=None, description="ID of the image associated with the lesson, if not set, it will be not updated")
    order: Optional[StrictInt] = Field(default=None, description="Order of the lesson in the module, if not set, it will be not updated")
    title: Optional[StrictStr] = Field(default=None, description="Title of the lesson, if not set, it will be not updated")
    payload: Optional[StrictStr] = Field(default=None, description="Payload of the lesson, if not set, it will be not updated")
    is_active: Optional[StrictBool] = Field(default=None, description="Whether the lesson is active or not, if not set, it will be not updated")
    is_published: Optional[StrictBool] = Field(default=None, description="Whether the lesson is published or not, if not set, it will be not updated")
    mandatory: Optional[StrictBool] = Field(default=None, description="Whether the lesson is mandatory or not, if not set, it will be not updated")
    __properties = ["submodule_id", "thread_id", "image_id", "order", "title", "payload", "is_active", "is_published", "mandatory"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ModuleLessonPatch:
        """Create an instance of ModuleLessonPatch from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ModuleLessonPatch:
        """Create an instance of ModuleLessonPatch from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ModuleLessonPatch.parse_obj(obj)

        _obj = ModuleLessonPatch.parse_obj({
            "submodule_id": obj.get("submodule_id"),
            "thread_id": obj.get("thread_id"),
            "image_id": obj.get("image_id"),
            "order": obj.get("order"),
            "title": obj.get("title"),
            "payload": obj.get("payload"),
            "is_active": obj.get("is_active"),
            "is_published": obj.get("is_published"),
            "mandatory": obj.get("mandatory")
        })
        return _obj


