# coding: utf-8

"""
    Mentortools Public API

    Mentortools public API service

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr

class Address(BaseModel):
    """
    Address
    """
    street_and_number: Optional[StrictStr] = Field(default=None, description="Street and number of the buyer's address, optional, but recommended")
    city: Optional[StrictStr] = Field(default=None, description="City of the buyer's address, optional, but recommended")
    postal_code: Optional[StrictStr] = Field(default=None, description="Postal code of the buyer's address, optional, but recommended")
    country: Optional[StrictStr] = Field(default=None, description="Country of the buyer's address, optional, but recommended")
    __properties = ["street_and_number", "city", "postal_code", "country"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Address:
        """Create an instance of Address from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Address:
        """Create an instance of Address from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Address.parse_obj(obj)

        _obj = Address.parse_obj({
            "street_and_number": obj.get("street_and_number"),
            "city": obj.get("city"),
            "postal_code": obj.get("postal_code"),
            "country": obj.get("country")
        })
        return _obj


