#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import datetime
import logging

from .timestamp import Timestamp

logger = logging.getLogger(__name__)
MILLISECONDS_PER_SECOND = 1000


class TimestampSec(Timestamp, float):
    def __new__(cls, value: int | float | datetime.datetime) -> 'TimestampSec':
        value = cls._prepare_value(value)
        while abs(value) > cls._MAX_TIMESTAMP_SEC:
            value /= MILLISECONDS_PER_SECOND

        # noinspection PyArgumentList
        return float.__new__(cls, value)

    def total_seconds(self) -> float:
        return float(self)
