### Time tools
Tools to organise consistent and fail proof time-based logic

### Minimal usage example
```python
import datetime
from time_tools import TimestampSec, Timerange
utc = datetime.timezone.utc

# Timestamp
some_client_timestamp_sec = 1234567890
other_client_timestamp_ms = 1234567890000
assert TimestampSec(some_client_timestamp_sec) == TimestampSec(other_client_timestamp_ms)

# TimeRange
allowed_timerange = Timerange(
    datetime.datetime(2024, 1, 1, tzinfo=utc),
    datetime.datetime(2024, 2, 1, tzinfo=utc)
)
desired_timerange = Timerange(
    datetime.datetime(2024, 1, 15, tzinfo=utc),
    datetime.datetime(2024, 2, 15, tzinfo=utc)
)
target_timerange = desired_timerange.intersection(allowed_timerange)
print(target_timerange.to_date_str())
assert target_timerange == Timerange(
    datetime.datetime(2024, 1, 15, tzinfo=utc),
    datetime.datetime(2024, 2, 1, tzinfo=utc)
)
```