#  Copyright (C) 2021
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasya Svintsov <v.svintsov@techokert.ru>, Alexander Medvedev <a.medvedev@abm-jsc.ru>

from aiohttp.hdrs import CONTENT_DISPOSITION, CONTENT_LENGTH

from ..file_descriptor import FileDescriptor


def get_file_headers(file_descriptor: FileDescriptor) -> dict[str, str]:
    return {
        CONTENT_DISPOSITION: f'attachment; filename="{file_descriptor.quoted_full_file_name}"',
        CONTENT_LENGTH: str(file_descriptor.size),
    }
