from typing import Any, Iterable, Type


class TableEngine:
    def __init__(self, name: str = 'undefined', args: Iterable[Any] = None):
        if args is None:
            args = []
        self.name = name
        self.args = list(args)

    def get_engine_sql(self) -> str:
        sql = self.name
        if self.args:
            sql += f'({", ".join(self.args)})'
        return sql

    def preprocess_select_request(self, select: 'Select') -> None:
        ...

    def apply(self, table: Type['Table']) -> None:
        ...

    @staticmethod
    def construct_from_sql(table: Type['Table']) -> str:
        return table.get_name()
