# coding: utf-8

"""
    Mentortools AI API

    Mentortools service for ai interactions

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conlist

class AiAssistantGoalGet(BaseModel):
    """
    AiAssistantGoalGet
    """
    id: StrictInt = Field(...)
    ai_assistant_id: StrictInt = Field(...)
    is_active: StrictBool = Field(...)
    engagement: StrictInt = Field(...)
    max_total_engagement_count: StrictInt = Field(...)
    max_engagement_count: StrictInt = Field(...)
    max_engagement_period: StrictInt = Field(...)
    engagement_opt_out_duration: StrictInt = Field(...)
    name: StrictStr = Field(...)
    page_url: Optional[StrictStr] = None
    course_ids: conlist(StrictInt) = Field(...)
    additional_prompt: StrictStr = Field(...)
    created_at: StrictInt = Field(...)
    last_updated_at: StrictInt = Field(...)
    is_fullfilled: Optional[StrictBool] = False
    is_available: Optional[StrictBool] = True
    __properties = ["id", "ai_assistant_id", "is_active", "engagement", "max_total_engagement_count", "max_engagement_count", "max_engagement_period", "engagement_opt_out_duration", "name", "page_url", "course_ids", "additional_prompt", "created_at", "last_updated_at", "is_fullfilled", "is_available"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AiAssistantGoalGet:
        """Create an instance of AiAssistantGoalGet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AiAssistantGoalGet:
        """Create an instance of AiAssistantGoalGet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return AiAssistantGoalGet.parse_obj(obj)

        _obj = AiAssistantGoalGet.parse_obj({
            "id": obj.get("id"),
            "ai_assistant_id": obj.get("ai_assistant_id"),
            "is_active": obj.get("is_active"),
            "engagement": obj.get("engagement"),
            "max_total_engagement_count": obj.get("max_total_engagement_count"),
            "max_engagement_count": obj.get("max_engagement_count"),
            "max_engagement_period": obj.get("max_engagement_period"),
            "engagement_opt_out_duration": obj.get("engagement_opt_out_duration"),
            "name": obj.get("name"),
            "page_url": obj.get("page_url"),
            "course_ids": obj.get("course_ids"),
            "additional_prompt": obj.get("additional_prompt"),
            "created_at": obj.get("created_at"),
            "last_updated_at": obj.get("last_updated_at"),
            "is_fullfilled": obj.get("is_fullfilled") if obj.get("is_fullfilled") is not None else False,
            "is_available": obj.get("is_available") if obj.get("is_available") is not None else True
        })
        return _obj


