# coding: utf-8

"""
    Fal.ai Video Connector

    FastAPI connector for fal.ai video generation using Wan 2.6 model

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt, StrictStr

class VideoOutputResponse(BaseModel):
    """
    VideoOutputResponse
    """
    url: StrictStr = Field(...)
    content_type: StrictStr = Field(...)
    width: StrictInt = Field(...)
    height: StrictInt = Field(...)
    fps: Optional[Union[StrictFloat, StrictInt]] = None
    duration: Optional[Union[StrictFloat, StrictInt]] = None
    __properties = ["url", "content_type", "width", "height", "fps", "duration"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> VideoOutputResponse:
        """Create an instance of VideoOutputResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if fps (nullable) is None
        # and __fields_set__ contains the field
        if self.fps is None and "fps" in self.__fields_set__:
            _dict['fps'] = None

        # set to None if duration (nullable) is None
        # and __fields_set__ contains the field
        if self.duration is None and "duration" in self.__fields_set__:
            _dict['duration'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> VideoOutputResponse:
        """Create an instance of VideoOutputResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return VideoOutputResponse.parse_obj(obj)

        _obj = VideoOutputResponse.parse_obj({
            "url": obj.get("url"),
            "content_type": obj.get("content_type"),
            "width": obj.get("width"),
            "height": obj.get("height"),
            "fps": obj.get("fps"),
            "duration": obj.get("duration")
        })
        return _obj


