# coding: utf-8

"""
    Fal.ai Video Connector

    FastAPI connector for fal.ai video generation using Wan 2.6 model

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr, constr
from fal_ai_connector.models.video_duration import VideoDuration
from fal_ai_connector.models.video_preset import VideoPreset

class ImageToVideoApiRequest(BaseModel):
    """
    ImageToVideoApiRequest
    """
    prompt: constr(strict=True, max_length=800) = Field(...)
    image_url: Optional[StrictStr] = None
    image_base64: Optional[StrictStr] = None
    preset: Optional[VideoPreset] = None
    duration: Optional[VideoDuration] = None
    __properties = ["prompt", "image_url", "image_base64", "preset", "duration"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ImageToVideoApiRequest:
        """Create an instance of ImageToVideoApiRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if image_url (nullable) is None
        # and __fields_set__ contains the field
        if self.image_url is None and "image_url" in self.__fields_set__:
            _dict['image_url'] = None

        # set to None if image_base64 (nullable) is None
        # and __fields_set__ contains the field
        if self.image_base64 is None and "image_base64" in self.__fields_set__:
            _dict['image_base64'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ImageToVideoApiRequest:
        """Create an instance of ImageToVideoApiRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ImageToVideoApiRequest.parse_obj(obj)

        _obj = ImageToVideoApiRequest.parse_obj({
            "prompt": obj.get("prompt"),
            "image_url": obj.get("image_url"),
            "image_base64": obj.get("image_base64"),
            "preset": obj.get("preset"),
            "duration": obj.get("duration")
        })
        return _obj


