#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasiliev Ivan <i.vasiliev@technokert.ru>
from dataclasses import dataclass, field
from typing import Any, Self

from ..base import Expression, AbstractFactory


FunctionArgType = Expression | str | int | float | bool


@dataclass
class Function(Expression):
    name: str
    call_args: tuple[FunctionArgType, ] = field(init=False)

    def __post_init__(self):
        self.name = self.name.lower()

    def __call__(self, *args: FunctionArgType) -> Self:
        self.call_args = args
        return self


class FunctionFactory(AbstractFactory):
    def __init__(self, _factory_type=Function):
        self._factory_type = _factory_type

    def __getattr__(self, key: Any):
        if not isinstance(key, str):
            raise ValueError(f"Cannot create column from non string key: {key}")
        return self._function_type(key)
