#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
import dataclasses


@dataclasses.dataclass(frozen=True)
class _NoDefault:
    """
    It should be equal `dataclasses.MISSING` to be ignored by dict_to_dataclass
    But shouldn't be `dataclasses.MISSING`, cos sqlalchemy breaks =(
    """
    def __eq__(self, other):
        return dataclasses.MISSING == other

    def __repr__(self):
        return f'{type(self).__name__}()'

    def __call__(self, *args, **kwargs):
        return self

    def __bool__(self):
        return False


NoDefault = _NoDefault()
