#  Copyright (C) 2024
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
from typing import Callable, Any

import pytest


def assert_call_result_eq_or_raises(target: Callable, *args, expected: Exception | Any, **kwargs) -> None:
    if isinstance(expected, Exception):
        with pytest.raises(type(expected), match=expected.args[0]):
            target(*args, **kwargs)
    else:
        assert target(*args, **kwargs) == expected
