#  Copyright (C) 2023
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Revva Konstantin <k.revva@abm-jsc.ru>


from dataclasses import dataclass


@dataclass(frozen=True)
class ShiftAnalyzeResult:
    stream_url: str
    snapshot_done_at: float
    analyzed_at: float
    certainty: float
    snapshot_file_id: str
    comparison_stopped_on_index: int
    similarity_threshold: float
    reference_image_file_ids: list[str]
