#  Copyright (C) 2021
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Mike Orlov <m.orlov@abm-jsc.ru>
#

from typing import Any, TypeVar, Union, Type

T = TypeVar('T')
F = TypeVar('F')


def try_cast(value: Any, target_type: Type[T], fallback_value: Any = None,
             fallback_on: Type[Exception] = Exception) -> Union[T, F]:
    try:
        return target_type(value)
    except fallback_on:
        return fallback_value
