#  Copyright (C) 2022
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasya Svintsov <v.svintsov@techokert.ru>

from dataclasses import dataclass

from http_tools.http_server_connector import HttpServerConnector

from .api_entities.abstract_api_entity import AbstractApiEntity
from .auth import Auth
from .api_entities.component import Component
from .api_entities.group import Group
from .api_entities.language import Language
from .api_entities.project import Project
from .api_entities.role import Role
from .api_entities.translation import Translation
from .api_entities.user import User


class WeblateClient:
    @dataclass
    class Config(HttpServerConnector.Config, Auth.Config):
        pass

    Context = HttpServerConnector.Context

    def __init__(self, config: Config, context: Context):
        api_entity_context = AbstractApiEntity.Context(
            auth=Auth(config=config),
            http_connector=HttpServerConnector(config=config, context=context)
        )

        self.user = User(context=api_entity_context)
        self.group = Group(context=api_entity_context)
        self.role = Role(context=api_entity_context)
        self.language = Language(context=api_entity_context)
        self.project = Project(context=api_entity_context)
        self.component = Component(context=api_entity_context)
        self.translation = Translation(context=api_entity_context)
