#  Copyright (C) 2022
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasya Svintsov <v.svintsov@techokert.ru>

from typing import Any

from furl import furl

from .abstract_api_entity import AbstractApiEntity


class Translation(AbstractApiEntity):
    def __init__(self, context: AbstractApiEntity.Context):
        super(Translation, self).__init__(context, "/translations")

    async def get_translations_file_content(self, project: str, component: str, language: str) -> Any:
        path = furl(self._base_path) / project / component / language / "file/"
        answer = await self._context.http_connector.get(path.tostr(), headers=self._context.auth.authorization_headers)
        return answer
