## SnapshotConnector

service to get snapshots from rtsp stream

## Library Installation

```
pip install --extra-index-url https://pypi.abm-jsc.ru snapshoter-connector-abm
```

## Quick Start


#### Getting snapshot
```python
import asyncio

import aiohttp
from snapshoter_connector.connector import SnapshotConnector


async def make_snapshot():
    
    session = aiohttp.ClientSession()

    email_service_connector = SnapshotConnector(
        config=SnapshotConnector.Config(
            url='127.0.0.1:8080'
        ),
        context=SnapshotConnector.Context(
            session=session,
            project_name="test"
        ),
    )
    rstp_url = "rtsp://login:pass@ip"
    snapshot = await email_service_connector.get_snapshot(rstp_url)
    print(len(snapshot))
    await session.close()


asyncio.run(make_snapshot())
```
