from dataclasses import dataclass
from enum import Enum, unique
from typing import Union

from ..utils.escape import escape
from .column import Column
from ..utils.to_list import to_list


def has_any_filter_parse(value_to_parse: Union[int, list]) -> str:
    value_to_parse = to_list(value_to_parse)
    value_to_parse = [to_list(value) for value in value_to_parse]
    # TODO: Spike for replace int to Int32 in sql request
    parsed_value = []
    for value in value_to_parse:
        string = []
        for val in value:
            string.append(f"toInt32({val})")
        parsed_value.append("[" + ", ".join(string) + "]")
    has_any_filter = "[" + ", ".join(parsed_value) + "]"
    return has_any_filter


def has_filter_parse(value_to_parse: Union[int]) -> str:
    # TODO: Spike for replace int to Int32 in sql request
    # if isinstance(value_to_parse, list):
    #     raise web.HTTPBadRequest(reason="Use 'hasAny' operator to parse list")
    string = f"toInt32({value_to_parse})"
    parsed_value = ("[" + string + "]")
    return parsed_value


@unique
class ComparisonOperator(str, Enum):
    lt = "<"
    le = "<="
    ne = "!="
    eq = "="
    ge = ">="
    gt = ">"
    has_any = "hasAny"
    has = "has"
    in_ = "in"


@dataclass
class Filter:
    attribute: Column
    value: Union[str, int, list]
    operator: ComparisonOperator

    def __str__(self):
        if self.operator == ComparisonOperator.has_any:
            value = has_any_filter_parse(self.value)
            return f"{self.operator}({escape(self.attribute)}, {value})"
        elif self.operator == ComparisonOperator.has:
            value = has_filter_parse(self.value)
            return f"{self.operator}({escape(self.attribute)}, {value})"
        elif isinstance(self.value, str):
            return f"{escape(self.attribute)} {self.operator} '{escape(self.value)}'"
        else:
            return f"{escape(self.attribute)} {self.operator} {self.value}"
