#  Copyright (C) 2021
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasya Svintsov <v.svintsov@techokert.ru>

from abc import ABC, abstractmethod
from typing import Union, List, Optional

from http_tools.attached_file import AttachedFile

from ..sending_result import SendingResult


class EmailClient(ABC):
    @abstractmethod
    async def send(self,
                   to_recipients: Union[str, List[str]],
                   subject: str,
                   body: str,
                   source_email_account: str,
                   *,
                   source_email_account_name: Optional[str] = None,
                   attachments: Optional[List[AttachedFile]] = None,
                   cc_recipients: Optional[Union[str, List[str]]] = None,
                   bcc_recipients: Optional[Union[str, List[str]]] = None
                   ) -> SendingResult:
        """
        Send the email.

        Note: source_email_account must be verified.

        :param to_recipients: The destination email accounts.
        :param subject: The subject of the email.
        :param body: The plain text/HTML version of the body of the email.
        :param source_email_account: The source email account.
        :param source_email_account_name: The name of the source email account.
        :param attachments: The attachment part of the body of the email.
        :param cc_recipients: The list of recipients on the 'CC'.
        :param bcc_recipients: The list of recipients on the 'BCC'.

        """
        ...
