"""Connector exceptions for DeepAgent API."""

from typing import Any


class DeepAgentAPIError(Exception):
    """Base exception for Deep Agent API errors."""

    def __init__(self, error_type: str, message: str, error_code: str | None = None) -> None:
        """Initialize exception.

        Args:
            error_type: Type of error (e.g., 'RunNotFoundError', 'AuthenticationError')
            message: Human-readable error message
            error_code: Optional error code for categorization
        """
        self.error_type = error_type
        self.error_code = error_code
        super().__init__(message)
