from dataclasses import dataclass, field

from utils.current_timestamp import get_current_timestamp_ms


@dataclass
class Notification:
    source_type_id: int
    source_id: int
    portal_id: int
    portal_member_id: int
    message: str
    visit_url: str
    notification_receivers: list[int] = field(default_factory=list)
    created_at: int = field(default_factory=get_current_timestamp_ms)
