# coding: utf-8

"""
    Mentortools Landing Page API

    Mentortools service for building and publishing landing pages

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, conlist
from landing_page_server_connector.models.landing_script import LandingScript

class LandingGet(BaseModel):
    """
    LandingGet
    """
    html: StrictStr = Field(...)
    css: StrictStr = Field(...)
    js: StrictStr = Field(...)
    components: Dict[str, Any] = Field(...)
    styles: conlist(Dict[str, Any]) = Field(...)
    assets: conlist(Dict[str, Any]) = Field(...)
    name: StrictStr = Field(...)
    title: StrictStr = Field(...)
    path: StrictStr = Field(...)
    order: StrictInt = Field(...)
    portal_id: StrictInt = Field(...)
    id: StrictInt = Field(...)
    uuid: StrictStr = Field(...)
    preview_id: Optional[StrictStr] = None
    google_analytics_pixel: Optional[StrictStr] = None
    google_tag_manager_pixel: Optional[StrictStr] = None
    facebook_pixel: Optional[StrictStr] = None
    tiktok_pixel: Optional[StrictStr] = None
    pinterest_pixel: Optional[StrictStr] = None
    custom_scripts: conlist(LandingScript) = Field(...)
    created_at: StrictInt = Field(...)
    updated_at: Optional[StrictInt] = None
    published_at: Optional[StrictInt] = None
    __properties = ["html", "css", "js", "components", "styles", "assets", "name", "title", "path", "order", "portal_id", "id", "uuid", "preview_id", "google_analytics_pixel", "google_tag_manager_pixel", "facebook_pixel", "tiktok_pixel", "pinterest_pixel", "custom_scripts", "created_at", "updated_at", "published_at"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> LandingGet:
        """Create an instance of LandingGet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in custom_scripts (list)
        _items = []
        if self.custom_scripts:
            for _item in self.custom_scripts:
                if _item:
                    _items.append(_item.to_dict())
            _dict['custom_scripts'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> LandingGet:
        """Create an instance of LandingGet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return LandingGet.parse_obj(obj)

        _obj = LandingGet.parse_obj({
            "html": obj.get("html"),
            "css": obj.get("css"),
            "js": obj.get("js"),
            "components": obj.get("components"),
            "styles": obj.get("styles"),
            "assets": obj.get("assets"),
            "name": obj.get("name"),
            "title": obj.get("title"),
            "path": obj.get("path"),
            "order": obj.get("order"),
            "portal_id": obj.get("portal_id"),
            "id": obj.get("id"),
            "uuid": obj.get("uuid"),
            "preview_id": obj.get("preview_id"),
            "google_analytics_pixel": obj.get("google_analytics_pixel"),
            "google_tag_manager_pixel": obj.get("google_tag_manager_pixel"),
            "facebook_pixel": obj.get("facebook_pixel"),
            "tiktok_pixel": obj.get("tiktok_pixel"),
            "pinterest_pixel": obj.get("pinterest_pixel"),
            "custom_scripts": [LandingScript.from_dict(_item) for _item in obj.get("custom_scripts")] if obj.get("custom_scripts") is not None else None,
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "published_at": obj.get("published_at")
        })
        return _obj


