#  Copyright (C) 2021
#  ABM, Moscow
#
#  UNPUBLISHED PROPRIETARY MATERIAL.
#  ALL RIGHTS RESERVED.
#
#  Authors: Vasya Svintsov <v.svintsov@techokert.ru>

from asyncio import Lock
from types import TracebackType
from typing import Type


class LockWrapper:
    def __init__(self) -> None:
        self.depth = 0
        self._lock = Lock()

    def _increase_depth(self) -> None:
        self.depth += 1

    def _decrease_depth(self) -> None:
        self.depth -= 1

    async def __aenter__(self) -> 'LockWrapper':
        self._increase_depth()
        await self._lock.__aenter__()
        return self

    async def __aexit__(self,
                        exc_type: Type[BaseException] | None,
                        exc: BaseException | None,
                        traceback: TracebackType | None) -> None:
        self._decrease_depth()
        await self._lock.__aexit__(exc_type, exc, traceback)

    async def acquire(self) -> None:
        self._increase_depth()
        await self._lock.acquire()

    def release(self) -> None:
        self._decrease_depth()
        self._lock.release()
